﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class TaxDB
    {
        public static Tax GetItem(Guid TaxID,string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@TaxID", ((TaxID != Guid.Empty && TaxID != null) ? TaxID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", ((keyword!=null && !string.IsNullOrEmpty(keyword)) ? keyword: (object)DBNull.Value)));

            return SQLHelper.RetrieveObject<Tax>("spGetTaxes", parameters);
        }

        public static List<Tax> GetList(Guid TaxID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@TaxID", ((TaxID != Guid.Empty && TaxID != null) ? TaxID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", ((keyword != null && !string.IsNullOrEmpty(keyword)) ? keyword : (object)DBNull.Value)));

            return SQLHelper.RetrieveList<Tax>("spGetTaxes", parameters);
        }

        public static void Save(Tax TaxItem)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            if (TaxItem.TaxID == Guid.Empty)
            {
                TaxItem.TaxID = Guid.NewGuid();
                TaxItem.IsActive = true;
            }

            parameters.Add(new SqlParameter("@TaxID", TaxItem.TaxID));
            parameters.Add(new SqlParameter("@TaxName", ((TaxItem.TaxName != null && !string.IsNullOrEmpty(TaxItem.TaxName)) ? TaxItem.TaxName : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@TaxDescription", ((TaxItem.TaxDescription != null && !string.IsNullOrEmpty(TaxItem.TaxDescription)) ? TaxItem.TaxDescription : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@TaxType", ((TaxItem.TaxType != null && !string.IsNullOrEmpty(TaxItem.TaxType)) ? TaxItem.TaxType : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@TaxValue", ((TaxItem.TaxValue != decimal.MinValue) ? TaxItem.TaxValue : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@CreatedBy", ((TaxItem.CreatedBy != null && TaxItem.CreatedBy != Guid.Empty) ? TaxItem.CreatedBy : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", TaxItem.IsActive));
            parameters.Add(new SqlParameter("@ApplyTaxAsDefault", TaxItem.ApplyTaxAsDefault));

            SQLHelper.ExecuteQuery("spAddOrUpdateTax", parameters);
        }

        public static void Delete(Guid TaxID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@TaxID", ((TaxID != Guid.Empty && TaxID != null) ? TaxID : (object)DBNull.Value)));

            SQLHelper.ExecuteQuery("spRemoveTax", parameters);
        }

        public static void SaveOrderTaxation(List<OrdersTax> OrderTaxing,Guid OrderID)
        {
            List<SqlParameter> parameters;
            foreach (OrdersTax ordtx in OrderTaxing)
            {
                parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@TaxID", ((ordtx.TaxID != null && ordtx.TaxID != Guid.Empty) ? ordtx.TaxID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@OrdersID", ((OrderID != null && OrderID != Guid.Empty) ? OrderID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@TaxName", ((ordtx.TaxName != null && ordtx.TaxName != string.Empty) ? ordtx.TaxName : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@TaxType", ((ordtx.TaxType != null && ordtx.TaxType != string.Empty) ? ordtx.TaxType : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@TaxValue", ((ordtx.TaxValue !=decimal.MinValue) ? ordtx.TaxValue : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@TaxAmount", ((ordtx.TaxAmount != decimal.MinValue) ? ordtx.TaxAmount : (object)DBNull.Value)));

                SQLHelper.ExecuteQuery("spAddOrUpdateOrderTaxing", parameters);
            }
        }

        public static List<OrdersTax> GetOrderTaxing(Guid OrderID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrderID", ((OrderID != Guid.Empty && OrderID != null) ? OrderID : (object)DBNull.Value)));

            return SQLHelper.RetrieveList<OrdersTax>("spGetOrderTaxing", parameters);
        }
    }
}
